<?xml version="1.0" ?>
<template expand_clusters="true" version="2">
    <!-- Updated on 2025-11-13T16:29:31.775372739 using eu-gerrit-1.euhpc.arm.com:29418/dsg/streamline - origin/changes/83/830983/1 (128f11507b5b58b15280689d64925b5636464515) - "Split out top down timeline charts where there are different divisors" -->
    <supported-cpuid id="Cortex-A32" />
    <chart average_cores="yes" average_selection="yes" height="61" percentage="yes" rendering_type="bar" series_composition="stacked" title="CPU Activity">
        <series color="58,223,67" description="User activity" display="AVERAGE" expression="$CPUActivityUser" name="User activity"/>
        <series color="223,71,66" description="System activity" display="AVERAGE" expression="$CPUActivitySystem" name="System activity"/>
    </chart>   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Branch MPKI">
        <series color="19,148,180" description="This metric measures the number of branch mispredictions per thousand instructions executed" expression="if(($BranchMPKICortexA32INST_RETIRED &gt; 0), (($BranchMPKICortexA32BR_MIS_PRED / $BranchMPKICortexA32INST_RETIRED) * 1000), 0)" name="Branch MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Cycles Per Instruction">
        <series color="19,148,180" description="This metric measures the number of cycles per instructions retired" expression="if(($CyclesPerInstructionCortexA32INST_RETIRED &gt; 0), ($CyclesPerInstructionCortexA32CPU_CYCLES / $CyclesPerInstructionCortexA32INST_RETIRED), 0)" name="Cycles Per Instruction" units="cycles"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instructions Per Cycle">
        <series color="19,148,180" description="This metric measures the number of instructions retired per cycle" expression="if(($InstructionsPerCycleCortexA32CPU_CYCLES &gt; 0), ($InstructionsPerCycleCortexA32INST_RETIRED / $InstructionsPerCycleCortexA32CPU_CYCLES), 0)" name="Instructions Per Cycle" units="instructions"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1D Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 data cache accesses missed to the total number of level 1 data cache accesses. This gives an indication of the effectiveness of the level 1 data cache." expression="if(($L1DCacheMissPercentageCortexA32L1D_CACHE &gt; 0), min(($L1DCacheMissPercentageCortexA32L1D_CACHE_REFILL / $L1DCacheMissPercentageCortexA32L1D_CACHE), 1), 0)" name="L1D Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1D Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheMPKICortexA32INST_RETIRED &gt; 0), (($L1DCacheMPKICortexA32L1D_CACHE_REFILL / $L1DCacheMPKICortexA32INST_RETIRED) * 1000), 0)" name="L1D Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Data TLB MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 data TLB accesses missed per thousand instructions executed" expression="if(($L1DataTLBMPKICortexA32INST_RETIRED &gt; 0), (($L1DataTLBMPKICortexA32L1D_TLB_REFILL / $L1DataTLBMPKICortexA32INST_RETIRED) * 1000), 0)" name="L1 Data TLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1I Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 instruction cache accesses missed to the total number of level 1 instruction cache accesses. This gives an indication of the effectiveness of the level 1 instruction cache." expression="if(($L1ICacheMissPercentageCortexA32L1I_CACHE &gt; 0), min(($L1ICacheMissPercentageCortexA32L1I_CACHE_REFILL / $L1ICacheMissPercentageCortexA32L1I_CACHE), 1), 0)" name="L1I Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1I Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 instruction cache accesses missed per thousand instructions executed" expression="if(($L1ICacheMPKICortexA32INST_RETIRED &gt; 0), (($L1ICacheMPKICortexA32L1I_CACHE_REFILL / $L1ICacheMPKICortexA32INST_RETIRED) * 1000), 0)" name="L1I Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Instruction TLB MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 instruction TLB accesses missed per thousand instructions executed" expression="if(($L1InstructionTLBMPKICortexA32INST_RETIRED &gt; 0), (($L1InstructionTLBMPKICortexA32L1I_TLB_REFILL / $L1InstructionTLBMPKICortexA32INST_RETIRED) * 1000), 0)" name="L1 Instruction TLB MPKI" units="misses"/>
    </chart>
    <select-metric id="ARMv8_Cortex_A32_metric_branch_mpki" />
    <select-metric id="ARMv8_Cortex_A32_metric_cpi" />
    <select-metric id="ARMv8_Cortex_A32_metric_ipc" />
    <select-metric id="ARMv8_Cortex_A32_metric_l1d_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A32_metric_l1d_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A32_metric_l1d_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_A32_metric_l1i_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A32_metric_l1i_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A32_metric_l1i_tlb_mpki" />
</template>
